% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPrediction.R
\name{getPrediction}
\alias{getPrediction}
\title{Enrollment and event prediction}
\usage{
getPrediction(
  df = NULL,
  to_predict = "enrollment and event",
  target_n = NA,
  target_d = NA,
  enroll_model = "b-spline",
  nknots = 0,
  lags = 30,
  accrualTime = 0,
  enroll_prior = NULL,
  event_model = "model averaging",
  piecewiseSurvivalTime = 0,
  k = 0,
  scale = "hazard",
  event_prior = NULL,
  dropout_model = "exponential",
  piecewiseDropoutTime = 0,
  k_dropout = 0,
  scale_dropout = "hazard",
  dropout_prior = NULL,
  fixedFollowup = FALSE,
  followupTime = 365,
  pilevel = 0.9,
  nyears = 4,
  nreps = 500,
  showEnrollment = TRUE,
  showEvent = TRUE,
  showDropout = FALSE,
  showOngoing = FALSE,
  showsummary = TRUE,
  showplot = TRUE,
  by_treatment = FALSE,
  ngroups = 1,
  alloc = NULL,
  treatment_label = NULL,
  covariates_event = NULL,
  event_prior_with_covariates = NULL,
  covariates_dropout = NULL,
  dropout_prior_with_covariates = NULL
)
}
\arguments{
\item{df}{The subject-level enrollment and event data, including
\code{trialsdt}, \code{usubjid}, \code{randdt}, and \code{cutoffdt} for
enrollment prediction, and, additionally, \code{time}, \code{event},
and \code{dropout} for event prediction. The data should also include
\code{treatment} coded as 1, 2, and so on, and
\code{treatment_description} for enrollment and
event prediction by treatment. By default, it is set to
\code{NULL} for enrollment and event prediction at the design stage.}

\item{to_predict}{Specifies what to predict: "enrollment only", "event
only", or "enrollment and event". By default, it is set to
"enrollment and event".}

\item{target_n}{The target number of subjects to enroll in the study.}

\item{target_d}{The target number of events to reach in the study.}

\item{enroll_model}{The enrollment model which can be specified as
"Poisson", "Time-decay", "B-spline", or
"Piecewise Poisson". By default, it is set to "B-spline".}

\item{nknots}{The number of inner knots for the B-spline enrollment
model. By default, it is set to 0.}

\item{lags}{The day lags to compute the average enrollment rate to
carry forward for the B-spline enrollment model. By default,
it is set to 30.}

\item{accrualTime}{The accrual time intervals for the piecewise
Poisson model. Must start with 0, e.g., c(0, 30) breaks the
time axis into 2 accrual intervals: [0, 30) and [30, Inf).
By default, it is set to 0.}

\item{enroll_prior}{The prior of enrollment model parameters.}

\item{event_model}{The event model used to analyze the event data
which can be set to one of the following options:
"exponential", "Weibull", "log-logistic", "log-normal",
"piecewise exponential", "model averaging", or "spline".
The model averaging uses the \code{exp(-bic/2)} weighting and
combines Weibull and log-normal models. By default, it is set to
"model averaging".}

\item{piecewiseSurvivalTime}{A vector that specifies the time
intervals for the piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{k}{The number of inner knots of the spline event model of
Royston and Parmar (2002). The default
\code{k=0} gives a Weibull, log-logistic or log-normal model,
if \code{scale} is "hazard", "odds", or "normal", respectively.
The knots are chosen as equally-spaced quantiles of the log
uncensored survival times. The boundary knots are chosen as the
minimum and maximum log uncensored survival times.}

\item{scale}{If "hazard", the log cumulative hazard is modeled
as a spline function. If "odds", the log cumulative odds is
modeled as a spline function. If "normal", -qnorm(S(t)) is
modeled as a spline function.}

\item{event_prior}{The prior of event model parameters.}

\item{dropout_model}{The dropout model used to analyze the dropout data
which can be set to one of the following options:
"none", "exponential", "Weibull", "log-logistic", "log-normal",
"piecewise exponential", "model averaging", or "spline".
The model averaging uses the \code{exp(-bic/2)} weighting and
combines Weibull and log-normal models. By default, it is set to
"exponential".}

\item{piecewiseDropoutTime}{A vector that specifies the time
intervals for the piecewise exponential dropout distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{k_dropout}{The number of inner knots of the spline dropout model of
Royston and Parmar (2002). The default
\code{k_dropout=0} gives a Weibull, log-logistic or log-normal model,
if \code{scale_dropout} is "hazard", "odds", or "normal", respectively.
The knots are chosen as equally-spaced quantiles of the log
uncensored survival times. The boundary knots are chosen as the
minimum and maximum log uncensored survival times.}

\item{scale_dropout}{If "hazard", the log cumulative hazard is modeled
as a spline function. If "odds", the log cumulative odds is
modeled as a spline function. If "normal", -qnorm(S(t)) is
modeled as a spline function.}

\item{dropout_prior}{The prior of dropout model parameters.}

\item{fixedFollowup}{A Boolean variable indicating whether a fixed
follow-up design is used. By default, it is set to \code{FALSE}
for a variable follow-up design.}

\item{followupTime}{The follow-up time for a fixed
follow-up design, in days. By default, it is set to 365.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nyears}{The number of years after the data cut for prediction.
By default, it is set to 4.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500.}

\item{showEnrollment}{A Boolean variable to control whether or not to
show the number of enrolled subjects. By default, it is set to
\code{TRUE}.}

\item{showEvent}{A Boolean variable to control whether or not to
show the number of events. By default, it is set to
\code{TRUE}.}

\item{showDropout}{A Boolean variable to control whether or not to
show the number of dropouts. By default, it is set to
\code{FALSE}.}

\item{showOngoing}{A Boolean variable to control whether or not to
show the number of ongoing subjects. By default, it is set to
\code{FALSE}.}

\item{showsummary}{A Boolean variable to control whether or not to
show the prediction summary. By default, it is set to \code{TRUE}.}

\item{showplot}{A Boolean variable to control whether or not to
show the plots. By default, it is set to \code{TRUE}.}

\item{by_treatment}{A Boolean variable to control whether or not to
predict by treatment group. By default, it is set to \code{FALSE}.}

\item{ngroups}{The number of treatment groups for enrollment prediction
at the design stage. By default, it is set to 1.
It is replaced with the actual number of
treatment groups in the observed data if \code{df} is not \code{NULL}.}

\item{alloc}{The treatment allocation in a randomization block.
By default, it is set to \code{NULL}, which yields equal allocation
among the treatment groups.}

\item{treatment_label}{The treatment labels for treatments in a
randomization block for design stage prediction.
It is replaced with the treatment_description
in the observed data if \code{df} is not \code{NULL}.}

\item{covariates_event}{The names of baseline covariates from the input
data frame to include in the event model, e.g., c("age", "sex").
Factor variables need to be declared in the input data frame.}

\item{event_prior_with_covariates}{The prior of event model parameters
in the presence of covariates.}

\item{covariates_dropout}{The names of baseline covariates from the input
data frame to include in the dropout model, e.g., c("age", "sex").
Factor variables need to be declared in the input data frame.}

\item{dropout_prior_with_covariates}{The prior of dropout model
parameters in the presence of covariates.}
}
\value{
A list that includes the fits of observed data models,
as well as simulated enrollment data for new subjects and
simulated event data for ongoing and new subjects.
}
\description{
Performs enrollment and event prediction by utilizing
observed data and specified enrollment and event models.
}
\details{
For the time-decay model, the mean function is
\code{mu(t) = mu/delta*(t - 1/delta*(1 - exp(-delta*t)))}
and the rate function is
\code{lambda(t) = mu/delta*(1 - exp(-delta*t))}.
For the B-spline model, the daily enrollment rate is approximated as
\code{lambda(t) = exp(B(t)*theta)},
where \code{B(t)} represents the B-spline basis functions.

The \code{enroll_prior} variable should be a list that
includes \code{model} to specify the enrollment model
(poisson, time-decay, or piecewise poisson),
\code{theta} and \code{vtheta} to indicate the parameter
values and the covariance matrix. One can use a very small
value of \code{vtheta} to fix the parameter values.
For the piecewise Poisson enrollment model, the list
should also include \code{accrualTime}. It should be noted
that the B-spline model is not appropriate for use as prior.

For event prediction by treatment with prior information,
the \code{event_prior} (\code{dropout_prior}) variable should be
a list with one element per treatment. For each treatment, the
element should include \code{model} to specify the event (dropout)
model (exponential, weibull, log-logistic, log-normal,
or piecewise exponential), \code{theta} and \code{vtheta} to
indicate the parameter values and the covariance matrix.
For the piecewise exponential event (dropout) model, the list
should also include \code{piecewiseSurvivalTime}
(\code{piecewiseDropoutTime}) to indicate the location of knots.
It should be noted that the model averaging and spline options
are not appropriate for use as prior.

If the event prediction is not by treatment while the prior
information is given by treatment, then each element of
\code{event_prior} (\code{dropout_prior}) should also include
\code{w} to specify the weight of the treatment in a
randomization block. If the prediction is not by treatment and
the prior is given for the overall study, then \code{event_prior}
(\code{dropout_prior}) is a flat list with \code{model},
\code{theta}, and \code{vtheta}. For the piecewise exponential
event (dropout) model, it should also include
\code{piecewiseSurvivalTime} (\code{piecewiseDropoutTime}) to
indicate the location of knots.

For analysis-stage enrollment and event prediction, the
\code{enroll_prior}, \code{event_prior}, and
\code{dropout_prior} are either set to \code{NULL} to
use the observed data only, or specify the prior distribution
of model parameters to be combined with observed data likelihood
for enhanced modeling flexibility.
}
\examples{
# Event prediction after enrollment completion

pred <- getPrediction(
  df = interimData2, to_predict = "event only",
  target_d = 200,
  event_model = "weibull",
  dropout_model = "exponential",
  pilevel = 0.90, nreps = 100)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
