% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife-cuminc.R
\name{leaveOneOut.competing.risks2}
\alias{leaveOneOut.competing.risks2}
\title{Compute jackknife pseudo-observations of the cause-specific cumulative incidence for competing risks}
\usage{
leaveOneOut.competing.risks2(object, times, cause, mr)
}
\arguments{
\item{object}{A survfit object, with competing events}

\item{times}{Times at which the cumulative incidence is computed, must be length 1}

\item{cause}{Value indicating for which cause the cumulative incidence is to be computed, it must match one of the values available in object (see example)}

\item{mr}{Model response, the result of a call to Surv, or a matrix with two columns: "time" (observed follow up time) and "status" (0 = censored, 1, ..., k = event types)}
}
\value{
A vector of jackknifed values of the cause-specific cumulative incidence at time times
}
\description{
Compute jackknife pseudo-observations of the cause-specific cumulative incidence for competing risks
}
\examples{

sfit.cuminc <- survival::survfit(survival::Surv(etime, event) ~ 1, data = mgus2)
mrs <- with(mgus2, Surv(etime, event))
jackvals <- leaveOneOut.competing.risks2(sfit.cuminc, times = 200, cause = "pcm", mrs)
}
