% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.multivariate.URW.shift.R
\name{fit.multivariate.URW.shift}
\alias{fit.multivariate.URW.shift}
\title{Fit separate multivariate Unbiased Random Walk models to two different segments of a multivariate evolutionary sequence (time-series).}
\usage{
fit.multivariate.URW.shift(
  yy,
  minb = 10,
  hess = FALSE,
  pool = TRUE,
  shift.point = NULL,
  method = "L-BFGS-B",
  trace = FALSE,
  iterations = NULL,
  iter.sd = NULL
)
}
\arguments{
\item{yy}{a multivariate evoTS object.}

\item{minb}{the minimum number of samples within a segment to consider.}

\item{hess}{logical, indicating whether to calculate standard errors from the Hessian matrix.}

\item{pool}{indicating whether to pool variances across samples}

\item{shift.point}{the sample in the time series that represents the first sample in the second segment.}

\item{method}{optimization method, passed to function optim. Default is "L-BFGS-B".}

\item{trace}{logical, indicating whether information on the progress of the optimization is printed.}

\item{iterations}{the number of times the optimization method is run from different starting points. Default is NULL, meaning the optimization is run once.}

\item{iter.sd}{defines the standard deviation of the Gaussian distribution from which starting values for the optimization routine is run. Default is 1.}
}
\value{
First part of the output reports the log-likelihood of the model and its AICc score. The second part of the output is the maximum log-likelihood model parameters (ancestral.values, R). The last part of the output gives information about the number of parameters in the model (K), number of samples in the data (n) and number of times the optimization routine was run (iter).
}
\description{
Function to find maximum likelihood solutions for multivariate Unbiased Random Walk models fitted to two different segments of a multivariate evolutionary sequence (time-series).
}
\details{
The function searches - using an optimization routine - for the maximum-likelihood solution for a multivariate Unbiased Random Walk model ti two non-overlapping segments in the time series.

The argument 'method' is passed to the 'optim' function and is included for the convenience of users to better control the optimization routine. The the default method (L-BFGS-B) seems to work for most evolutionary sequences.

Initial estimates to start the optimization come from maximum-likelihood estimates of the univariate Unbiased Random Walk model (from the paleoTS package) fitted to each time-series separately.

It is good practice to repeat any numerical optimization procedure from different starting points. This is especially important for complex models as the log-likelihood surface might contain more than one peak. The number of iterations is controlled by the argument 'iterations'. The function will report the model parameters from the iteration with the highest log-likelihood.
}
\note{
The models have been implemented to be compatible with the joint parameterization routine in the package paleoTS. The optimization is therefore fit using the actual sample values, with the autocorrelation among samples accounted for in the log-likelihood function. The joint distribution of sample means is multivariate normal, with means and variance-covariances determined by evolutionary parameters and sampling errors.
}
\examples{
## Generate an evoTS object by simulating a multivariate dataset
x <- sim.multi.URW(60)

## Fit two multivariate Unbiased Random Walk models to separate parts of the time-series.
fit.multivariate.URW.shift(x, shift.point = 31)
}
\references{
Revell, L. J. & Harmon, L. Testing quantitative genetic hypotheses about the evolutionary rate matrix for continuous characters. \emph{Evolutionary Ecology Research} 10, 311–331 (2008).
}
\author{
Kjetil Lysne Voje
}
