% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootstrapRep.R
\name{BootstrapRep}
\alias{BootstrapRep}
\title{Bootstrap analysis via resampling}
\usage{
BootstrapRep(
  ind.data,
  ComparisonFunc,
  iterations = 1000,
  sample.size = dim(ind.data)[1],
  correlation = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{ind.data}{Matrix of residuals or individual measurements}

\item{ComparisonFunc}{comparison function}

\item{iterations}{Number of resamples to take}

\item{sample.size}{Size of resamples, default is the same size as ind.data}

\item{correlation}{If TRUE, correlation matrix is used, else covariance matrix.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
returns the mean repeatability, that is, the mean value of comparisons from samples to original statistic.
}
\description{
Calculates the repeatability of the covariance matrix of the supplied data
  via bootstrap resampling
}
\details{
Samples with replacement are taken from the full population, a statistic calculated
  and compared to the full population statistic.
}
\examples{
BootstrapRep(iris[,1:4], MantelCor, iterations = 5, correlation = TRUE)
             
BootstrapRep(iris[,1:4], RandomSkewers, iterations = 50)

BootstrapRep(iris[,1:4], KrzCor, iterations = 50, correlation = TRUE)

BootstrapRep(iris[,1:4], PCAsimilarity, iterations = 50)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#BootstrapRep(iris[,1:4], PCAsimilarity,
#             iterations = 5,
#             parallel = TRUE)
}
\seealso{
\code{\link{MonteCarloStat}}, \code{\link{AlphaRep}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{bootstrap}
\keyword{repetabilities}
