% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abm-saa.R
\name{abm.saa}
\alias{abm.saa}
\title{abm.saa}
\usage{
abm.saa(objective, options = NULL)
}
\arguments{
\item{objective}{An instance of ObjectiveFunction (or subclass) class \link{ObjectiveFunction}}

\item{options}{An apropiate instance from a sublclass of \link{Options} class}
}
\value{
The best solution.
}
\description{
An implementation of Simulated Annealing Algorithm
optimization method for parameter estimation of Individual-based
models.
}
\examples{
\dontrun{
 f<- PlainFunction$new(f0.rosenbrock2)

 f$Parameter(name="x1",min=-100,max=100)
 f$Parameter(name="x2",min=-100,max=100)

 extremize("saa", f)
}

\dontrun{
 ## A Repast defined function
 f<- RepastFunction$new("/usr/models/BactoSim(HaldaneEngine-1.0)","ds::Output",300)

 ## or a plain function

 f1<- function(x1,x2,x3,x4) {
   10 * (x1 - 1)^2 + 20 * (x2 - 2)^2 + 30 * (x3 - 3)^2 + 40 * (x4 - 4)^2
 }

 f<- PlainFunction$new(f1)

 f$addFactor(name="cyclePoint",min=0,max=90)
 f$addFactor(name="conjugationCost",min=0,max=100)
 f$addFactor(name="pilusExpressionCost",min=0,max=100)
 f$addFactor(name="gamma0",min=1,max=10)

 abm.saa(f, 100, 1,  100, 0.75)
}

}
\references{
[1] Kirkpatrick, S., Gelatt, C. D., & Vecchi, M. P. (1983).
Optimization by Simulated Annealing. Science, 220(4598).
}
