% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{PhiCoefficient}
\alias{PhiCoefficient}
\title{Phi-Coefficient}
\usage{
PhiCoefficient(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
A matrix of phi coefficients with exametrika class.
Each element (i,j) represents the phi coefficient between items i and j.
The matrix is symmetric with ones on the diagonal.
}
\description{
The phi coefficient is the Pearson's product moment correlation coefficient
between two binary items. This function is applicable only to binary response data.
The coefficient ranges from -1 to 1, where 1 indicates perfect positive correlation,
-1 indicates perfect negative correlation, and 0 indicates no correlation.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# example code
# Calculate Phi-Coefficient using sample dataset J15S500
PhiCoefficient(J15S500)
}
