% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02D_StudentAnalysis.R
\name{StudentAnalysis}
\alias{StudentAnalysis}
\title{StudentAnalysis}
\usage{
StudentAnalysis(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.
\itemize{
\item ID: Student identifier
\item NR: Number of responses
\item NRS: Number-right score (total correct answers)
\item PR: Passage rate (proportion correct)
\item SS: Standardized score (z-score)
\item Percentile: Student's percentile rank
\item Stanine: Student's stanine score (1-9)
}}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
Returns a data frame containing the following columns for each student:
\itemize{
\item ID: Student identifier
\item NR: Number of responses
\item NRS: Number-right score (total correct answers)
\item PR: Passage rate (proportion correct)
\item SS: Standardized score (z-score)
\item Percentile: Student's percentile rank
\item Stanine: Student's stanine score (1-9)
}
}
\description{
The StudentAnalysis function returns descriptive statistics for each individual student.
Specifically, it provides the number of responses, the number of correct answers,
the passage rate, the standardized score, the percentile, and the stanine.
}
\examples{
# using sample dataset
StudentAnalysis(J15S500)
}
