% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_labels.R
\name{use_labels}
\alias{use_labels}
\title{Use Qualtrics labels as column names}
\usage{
use_labels(x)
}
\arguments{
\item{x}{Data frame imported using \code{qualtRics::fetch_survey()}.}
}
\value{
An object of the same type as \code{x} that has column names using the labels
generated in Qualtrics.
}
\description{
The \code{use_labels()} function renames the columns using the labels generated
in \href{https://www.qualtrics.com/}{Qualtrics}.  Data must be imported using
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
}
\examples{
# Rename columns
data(qualtrics_fetch)
qualtrics_renamed <- qualtrics_fetch \%>\%
  use_labels()
names(qualtrics_fetch)
names(qualtrics_renamed)
}
\seealso{
Other column name functions: 
\code{\link{rename_columns}()}
}
\concept{column name functions}
\concept{helper}
