% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_methods.R
\name{print.spm}
\alias{print.spm}
\title{Print method for an \code{"spm"} object}
\usage{
\method{print}{spm}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{an object of class \code{c("spm", "exdex")}, a result of
a call to \code{\link{spm}}.}

\item{digits}{The argument \code{digits} to \code{\link{print.default}}.}

\item{...}{Additional arguments.  None are used in this function.}
}
\value{
The argument \code{x}, invisibly, as for all
  \code{\link[base]{print}} methods.
}
\description{
\code{print} method for class \code{c("spm", "exdex")}.
}
\details{
Prints the original call to \code{\link{spm}}
  and the estimates of the extremal index \eqn{\theta}, based on all three
  variants of the semiparametric maxima estimator and both sliding
  and disjoint blocks.
}
\seealso{
\code{\link{spm}} for estimation of the extremal index
  \eqn{\theta} using a semiparametric maxima method.

\code{\link{confint.spm}}: \code{confint} method for
  class \code{"spm"}.
}
