% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{evaluate_na}
\alias{evaluate_na}
\title{Evaluate the dispersion of NAs}
\usage{
evaluate_na(i, pheno)
}
\arguments{
\item{i}{list of numeric indices of the data.frame}

\item{pheno}{Data.frame}
}
\value{
The optimum value to reduce
}
\description{
Looks how are \code{NA} distributed in each subset
}
\examples{
samples <- 10
m <- matrix(rnorm(samples), nrow = samples)
m[sample(seq_len(samples), size = 5), ] <- NA # Some NA
i <- create_subset(samples, 3, 4) # random subsets
evaluate_na(i, m)
}
\seealso{
Other functions to evaluate samples: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_independence}()},
\code{\link{evaluate_index}()},
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_orig}()},
\code{\link{evaluate_sd}()}

Other functions to evaluate categories: 
\code{\link{evaluate_entropy}()},
\code{\link{evaluate_independence}()}

Other functions to evaluate numbers: 
\code{\link{evaluate_mad}()},
\code{\link{evaluate_mean}()},
\code{\link{evaluate_sd}()}
}
\concept{functions to evaluate categories}
\concept{functions to evaluate numbers}
\concept{functions to evaluate samples}
