% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore_density}
\alias{explore_density}
\title{Explore density of variable}
\usage{
explore_density(
  data,
  var,
  target,
  title = "",
  min_val = NA,
  max_val = NA,
  color = c("lightgrey", "#939FB9"),
  auto_scale = TRUE,
  max_target_cat = 5,
  ...
)
}
\arguments{
\item{data}{A dataset}

\item{var}{Variable}

\item{target}{Target variable (0/1 or FALSE/TRUE)}

\item{title}{Title of the plot (if empty var name)}

\item{min_val}{All values < min_val are converted to min_val}

\item{max_val}{All values > max_val are converted to max_val}

\item{color}{Color of plot}

\item{auto_scale}{Use 0.02 and 0.98 percent quantile for min_val and max_val (if min_val and max_val are not defined)}

\item{max_target_cat}{Maximum number of levels of target shown in the plot (except NA).}

\item{...}{Further arguments}
}
\value{
Plot object (density plot)
}
\description{
Create a density plot to explore numerical variable
}
\examples{
explore_density(iris, "Sepal.Length")
iris$is_virginica <- ifelse(iris$Species == "virginica", 1, 0)
explore_density(iris, Sepal.Length, target = is_virginica)
}
