% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.1-predict.R
\docType{methods}
\name{exprso-predict}
\alias{exprso-predict}
\alias{predict,ExprsMachine-method}
\alias{predict,ExprsModule-method}
\alias{predict,RegrsModel-method}
\alias{predict,ExprsEnsemble-method}
\title{Deploy Model}
\usage{
\S4method{predict}{ExprsMachine}(object, array, verbose = TRUE)

\S4method{predict}{ExprsModule}(object, array, verbose = TRUE)

\S4method{predict}{RegrsModel}(object, array, verbose = TRUE)

\S4method{predict}{ExprsEnsemble}(object, array, how = "probability",
  verbose = TRUE)
}
\arguments{
\item{object}{An \code{ExprsModel} or \code{ExprsEnsemble} object.}

\item{array}{An \code{ExprsArray} object. The target data.}

\item{verbose}{A logical scalar. Argument passed to \code{calcStats}.}

\item{how}{A character string. Select from "probability" or "majority".
See Details. Argument applies to binary classifier ensembles only.}
}
\value{
Returns an \code{ExprsPredict} or \code{RegrsPredict} object.
}
\description{
Deploy a model to predict outcomes from the data.
}
\details{
Models can only get deployed on an object of the type used to build
 the model. Binary classification and regression are handled natively
 by the machine learning algorithm chosen. Multi-class classification
 is handled by \code{\link{doMulti}}. Note that a validation set
 should never get modified once separated from the training set.
 See \code{\link{buildEnsemble}} to learn about ensembles.

For binary classifier ensembles, when \code{how = "probability"}, outcomes
 are based on the average class probability (via \code{@probability})
 estimated by each deployed model. When \code{how = "majority"}, outcomes
 are based on consensus voting whereby each deployed model casts a single
 (all-or-nothing) vote (via \code{@pred}) in a winner takes all approach.
 In both scenarios, ties get broken randomly (as weighted by class).

For multi-class classifier ensembles, outcomes are based on the
 \code{how = "majority"} method from above. For regression ensembles,
 outcomes are based on the average predicted value.
}
