% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_hux.R
\name{as_huxtable.etable}
\alias{as_huxtable.etable}
\alias{as_hux.etable}
\title{Convert table to huxtable}
\usage{
as_huxtable.etable(x, ...)

as_hux.etable(x, ...)
}
\arguments{
\item{x}{etable. Table to convert to a huxtable.}

\item{...}{arguments passed on to \link[huxtable]{huxtable}.}
}
\description{
This function converts a \code{etable} object to a \code{huxtable}.
The \code{\link[huxtable]{huxtable-package}} needs to be installed to use this function.
}
\details{
\code{huxtable} allows to export formated tables to LaTeX, HTML, Microsoft Word, 
Microsoft Excel, Microsoft Powerpoint, RTF and Markdown.

Tables in knitr or rmarkdown documents of type LaTeX or Word 
are converted by default.
}
\examples{
\dontrun{ 
library(huxtable)
data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      cyl = "Number of cylinders",
                      disp = "Displacement (cu.in.)",
                      hp = "Gross horsepower",
                      drat = "Rear axle ratio",
                      wt = "Weight (1000 lbs)",
                      qsec = "1/4 mile time",
                      vs = "Engine",
                      vs = c("V-engine" = 0,
                             "Straight engine" = 1),
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      carb = "Number of carburetors"
)

tab = mtcars \%>\% 
    tab_cols(total(), am \%nest\% vs) \%>\% 
    tab_cells(mpg, hp) \%>\% 
    tab_stat_mean() \%>\% 
    tab_cells(cyl) \%>\% 
    tab_stat_cpct() \%>\% 
    tab_pivot() \%>\% 
    set_caption("Table 1. Some variables from mtcars dataset.")

ht = as_huxtable(tab)
ht
}
}
