% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_calc.R
\name{line_calc}
\alias{line_calc}
\title{Line data calculation}
\usage{
line_calc(line_layer, higher_geo_lay, unique_id_code, crs)
}
\arguments{
\item{line_layer}{multilinestring object of class \code{sf}, \code{sfc} or \code{sfg}.}

\item{higher_geo_lay}{multipologon object of class \code{sf}, \code{sfc} or \code{sfg}.}

\item{unique_id_code}{a string; indicating a unique ID column of \code{higher_geo_lay},
used as the summary areas.}

\item{crs}{coordinate reference system: integer with the EPSG code, or character based on proj4string.}
}
\value{
a \code{tibble} data frame object containing four columns:

the \code{unique_id_code} of \code{higher_geo_lay}

the total area of each polygon
in \code{higher_geo_lay} (TotalArea)

the total length of \code{line_layer} features (TotalLength)

the ratio between the total length of \code{line_layer} and the the total area of
\code{higher_geo_lay} polygon (Ratio).
}
\description{
Computes three different summary statistics:
(1) \code{TotalArea} total area of each polygon;
(2) \code{TotalLength} total length of a multilinestring object within a polygon
(3) \code{Ratio} ratio between \code{TotalLength} and \code{TotalArea} i.e.
the ratio between the total length and total area of a higher-order geography polygon.
}
\examples{
# Run line_calc() using the packages' dummy data sets.
# The data sets are georeferenced on wgs84. However, a planar system is used to measure areas.
# For the examples provided here, points and polygons relate to the United Kingdom.
# So the British National Grid is used.

## Not run:
outcome <- line_calc(
 line_layer = lines,
 higher_geo_lay = pol_large,
 unique_id_code = "large_pol_",
 crs = "epsg:27700")
## End(Not run)

}
