\name{predict.extraTrees}
\alias{predict.extraTrees}
\title{Function for making predictions from trained ExtraTree object.}
\description{
  This function makes predictions for regression/classification using the given trained ExtraTree object and provided input matrix (newdata).
}
\usage{
  \method{predict}{extraTrees}(object, newdata, ...)
}
\arguments{
  \item{object}{ extraTree (S3) object, created by extraTrees(). }
  \item{newdata}{ a new numberic input data matrix, for each row a prediction is made. }
  \item{...}{ not used currently. }
}
\value{
  The vector of predictions from the ExtraTree et. The length of the vector is equal to the the number of rows in newdata.
}
\author{Jaak Simm}
\examples{
  ## Regression with ExtraTrees:
  n <- 1000  ## number of samples
  p <- 5     ## number of dimensions
  x <- matrix(runif(n*p), n, p)
  y <- (x[,1]>0.5) + 0.8*(x[,2]>0.6) + 0.5*(x[,3]>0.4) + 0.1*runif(nrow(x))
  et <- extraTrees(x, y, nodesize=3, mtry=p, numRandomCuts=2)
  yhat <- predict(et, x)
}
\keyword{regression,classification,trees}

