% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremeStat-package.R
\docType{package}
\name{extremeStat}
\alias{extremeStat}
\alias{extremeStat-package}
\title{Extreme value statistics on a linear scale}
\description{
Fit (via L moments), plot (on a linear scale) and compare (by goodness of fit)
several (extreme value) distributions.
Compute high quantiles even in small samples and estimate extrema at given return periods.\cr
Open the \href{https://cran.r-project.org/package=extremeStat/vignettes/extremeStat.html}{Vignette}
for an introduction to the package: \code{vignette("extremeStat")}\cr
This package heavily relies on and thankfully acknowledges the package \code{lmomco} by WH Asquith.
}
\section{Package overview}{


The main functions in the extremeStat package are:
\tabular{ll}{
\code{\link{distLweights}} \tab -> \code{\link{plotLweights}}    \cr
\code{\link{distLfit}}     \tab -> \code{\link{plotLfit}}     \cr
\code{\link{q_gpd}} + \code{\link{q_weighted}} -> \code{\link{distLquantile}} \tab -> \code{\link{plotLquantile}} \cr
\code{\link{distLextreme}} \tab -> \code{\link{plotLextreme}} \cr
\code{\link{distLexBoot}}  \tab \cr
}
They create and modify a list object printed by (and documented in) \code{\link{printL}}.
}

\examples{
data(annMax) # annual discharge maxima from a stream in Austria
plot(annMax, type="l")
dle <- distLextreme(annMax)
dle$returnlev

}
\seealso{
If you are looking for more detailed (uncertainty) analysis, eg confidence intervals,
check out the package \code{extRemes}, especially the function \code{\link[extRemes]{fevd}}.
\url{https://cran.r-project.org/package=extRemes}\cr
Intro slides: \url{http://sites.lsa.umich.edu/eva2015/wp-content/uploads/sites/44/2015/06/Intro2EVT.pdf}\cr
Parameter fitting and distribution functions: \url{https://cran.r-project.org/package=lmomco}\cr
Distributions: \url{https://www.rmetrics.org/files/Meielisalp2009/Presentations/Scott.pdf}
and: \url{https://cran.r-project.org/view=Distributions} \cr
R in Hydrology: \url{http://abouthydrology.blogspot.de/2012/08/r-resources-for-hydrologists.html}\cr
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, 2014-2016
}
\keyword{documentation}
\keyword{package}
