% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{predict.hill.adapt}
\alias{predict.hill.adapt}
\title{Predict the adaptive Survival or Quantile function}
\usage{
\method{predict}{hill.adapt}(object, newdata = NULL, type = "quantile", ...)
}
\arguments{
\item{object}{output object of the function hill.adapt.}

\item{newdata}{optionally, a vector with which to predict. If omitted, the original data points are used.}

\item{type}{either "quantile" or "survival".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function provide the quantile assiociated to the adaptive model for the probability grid (transformed to -log(1-p) in the output) if type = "quantile". And the survival function assiociated to the adaptive model for the quantile grid if type = "survival".
}
\description{
Give the adaptive survival function or quantile function
}
\details{
If type = "quantile", \eqn{newdata} must be between 0 and 1. If type = "survival", \eqn{newdata} must be in the domain of the data from the \code{hill.adapt} function.
}
\examples{
x <- rparetoCP(1000)

HH <- hill.adapt(x, weights=rep(1, length(x)), initprop = 0.1,
               gridlen = 100 , r1 = 0.25, r2 = 0.05, CritVal=10)

newdata <- probgrid(p1 = 0.01, p2 = 0.999, length = 100)
pred.quantile <- predict(HH, newdata, type = "quantile")
newdata <- seq(0, 50, 0.1)
pred.survival <- predict(HH, newdata, type = "survival")#survival function

#compare the theorical quantile and the adaptive one.
predict(HH, 0.9999, type = "quantile")
qparetoCP(0.9999)

#compare the theorical probability and the adaptive one assiociated to a quantile.
predict(HH, 20, type = "survival")
1 - pparetoCP(20)

}
\seealso{
\code{\link{hill.adapt}}
}
