% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/time_spline_data.R
\name{make_boot_splines_data}
\alias{make_boot_splines_data}
\alias{make_boot_splines_data.time_sequence_data}
\title{Bootstrap resample splines for time-series data.}
\usage{
make_boot_splines_data(data, predictor_column, within_subj, aoi, smoother,
  samples, resolution, alpha)

\method{make_boot_splines_data}{time_sequence_data}(data, predictor_column,
  within_subj, aoi = NULL, smoother = "smooth.spline", samples = 1000,
  resolution = NULL, alpha = 0.05)
}
\arguments{
\item{data}{The output of \code{time_sequence_data()}}

\item{predictor_column}{What predictor var to split by? Maximum two conditions}

\item{within_subj}{Are the two conditions within or between subjects?}

\item{aoi}{Which AOI do you wish to perform the analysis on?}

\item{smoother}{Smooth data using "smooth.spline," "loess," or leave NULL for no smoothing}

\item{samples}{How many iterations to run bootstrap resampling? Default 1000}

\item{resolution}{What resolution should we return predicted splines at, in ms? e.g., 10ms = 100
intervals per second, or hundredths of a second. Default is the same size as time-bins.}

\item{alpha}{p-value when the groups are sufficiently "diverged"}
}
\value{
A bootstrapped distribution of samples for each time-bin
}
\description{
Bootstrap splines from \code{time_sequence_data()}. This creates a distribution from which a non-parametric
analysis can be performed.
}
\section{Methods (by class)}{
\itemize{
\item \code{time_sequence_data}: 
}}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition,
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE )
response_window <- subset_by_window(data, window_start_time = 15500,
                                    window_end_time = 21000, rezero = FALSE)
response_time <- make_time_sequence_data(response_window, time_bin_size = 500, aois = "Animate",
                                         predictor_columns = "Sex",
                                         summarize_by = "ParticipantName")

df_bootstrapped <- make_boot_splines_data(response_time,
                                          predictor_column = 'Sex',
                                          within_subj = FALSE,
                                          samples = 500,
                                          alpha = .05,
                                          smoother = "smooth.spline")
}

