% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-drm.R
\name{get_drm}
\alias{get_drm}
\title{Function to generate a dose-response model from a data frame.}
\usage{
get_drm(x, form = NULL, model = c("LL.3", "LL.4", "W1.4", "W2.4"),
  idcol = "ID")
}
\arguments{
\item{x}{a data frame that has at least the columns listed in the \code{form}
argument (e.g. "response" and "dose", see examples).}

\item{form}{a formula specifying the column names for the response and dose.
Defaults to NULL.}

\item{model}{one of 4 options:
\itemize{
   \item LL.3 = Log Logistic 3 parameter with a lower limit of 0.
   \item LL.4 = Log Logistic 4 parameter with lower limit estimated.
   \item W1.4 = Weibul 4 parameter type 1.
   \item W2.4 = Weibul 4 parameter type 2.
}}

\item{idcol}{the name of the column that identifies the samples (case sensitive).}
}
\description{
Function to generate a dose-response model from a data frame.
}
\details{
A wrapper function for \code{\link[drc]{drm}}, this will attempt to
  catch errors generated due to non-finite responses. When these are
  encounterd, a message that the model was not evaluated will be printed to
  the screen and NA will be returned.
}
\author{
Zhian N. Kamvar
}
\keyword{internal}

