% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DVARS.R
\name{pct_sig}
\alias{pct_sig}
\title{Convert data values to percent signal.}
\usage{
pct_sig(X, center = median, by = c("column", "all"))
}
\arguments{
\item{X}{a \eqn{T} by \eqn{N} numeric matrix. The columns will be normalized to
percent signal.}

\item{center}{A function that computes the center of a numeric vector.
Default: \code{median}. Other common options include \code{mean} and
\code{mode}.}

\item{by}{Should the center be measured individually for each \code{"column"}
(default), or should the center be the same across \code{"all"} columns?}
}
\value{
\code{X} with its columns normalized to percent signal. (A value of
85 will represent a -15\% signal change.)
}
\description{
Convert data values to percent signal.
}
