% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_matrix.R
\name{scale_timeseries}
\alias{scale_timeseries}
\title{Scale the BOLD timeseries}
\usage{
scale_timeseries(
  BOLD,
  scale = c("auto", "mean", "sd", "none"),
  transpose = TRUE
)
}
\arguments{
\item{BOLD}{Input fMRI data (V x T)}

\item{scale}{Option for scaling units.

\if{html}{\out{<div class="sourceCode">}}\preformatted{If \code{"auto"} (default), will use mean scaling except if demeaned data
is detected, in which case sd scaling will be used instead.

\code{"mean"} scaling will scale the data to percent local signal change.

\code{"sd"} scaling will scale the data by local standard deviation.

\code{"none"} will only center the data, not scale it.
}\if{html}{\out{</div>}}}

\item{transpose}{Check orientation of data, which, if TRUE, will transpose
the data when the number of time points is greater than the number of voxels.
Note: this is not always true for subcortical regions.}
}
\value{
Scale to units of percent local signal change and centers
}
\description{
Scale the BOLD timeseries
}
