% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabregCI.R
\name{ebayes_est}
\alias{ebayes_est}
\title{Empirical Bayes estimation of hyperparameters}
\usage{
ebayes_est(y, X, emu = FALSE, dof = min(50, round(0.5 * (dim(X)[1] -
  dim(X)[2]))))
}
\arguments{
\item{y}{a numeric vector of data}

\item{X}{a design matrix}

\item{emu}{(logical) estimate mean of coefficient (TRUE) or assume it is 
zero (FALSE)?}

\item{dof}{degrees of freedom to use for the t-quantiles (the remainder 
go to adaptive estimation of the prior)}
}
\value{
A list (s,sigma2,tau2,mu) where 
\enumerate{
\item s an estimate of the error standard deviation 
\item sigma2 an estimate of the error variance, independent of s
\item tau2 an estimate of the coefficient variance, independent of s
\item mu an estimate of the coefficient mean, independent of s
}
}
\description{
Compute emprirical Bayes estimates of the 
error variance and distribution of the regression coefficients.
}
\details{
This function computes the adaptive FAB 
confidence interval for each coefficient in 
a linear regression model.
}
\author{
Peter Hoff
}

