% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifabCI.R
\name{multifabCI}
\alias{multifabCI}
\title{Multigroup FAB t-intervals}
\usage{
multifabCI(y, g, alpha = 0.05)
}
\arguments{
\item{y}{a numeric vector of data}

\item{g}{a group membership vector, of the same length as y}

\item{alpha}{the type I error rate, so 1-alpha is the coverage rate}
}
\description{
Computation of 1-alpha FAB t-intervals for heteroscedastic
multigroup data.
}
\details{
For each group j, this function computes an estimate of 
the parameters in a hierarchical model for means and variances
from data other than group j, and uses this information to 
construct a FAB t-interval for group j. These intervals have 
1-alpha frequentist coverage, assuming within-group normality.
}
\examples{
## -- simulated data
p<-10 ; n<-10
y<-rnorm(n*p) ; g<-rep(1:p,n) 

## -- more interesting data takes longer 
# data(radon) ; y<-radon[,2] ; g<-radon[,1] 

## -- FAB t-intervals
FCI<-multifabCI(y,g) 

## -- UMAU t-intervals 
ybar<-tapply(y,g,mean) ; ssd<-tapply(y,g,sd) ; n<-table(g) 
qtn<-cbind( qt(.025,n-1),  qt(.975,n-1) ) 
UCI<-sweep(sweep(qtn,1,ssd/sqrt(n),"*"),1,ybar,"+") 

mean( (UCI[,2]-UCI[,1])/(FCI[,2]-FCI[,1]) , na.rm=TRUE)

}
\author{
Peter Hoff
}
\keyword{htest}

