% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-viz.R
\name{plot_pie_valid_value}
\alias{plot_pie_valid_value}
\title{Draw pie chart of one column in a tibble (valid and non-valid values)}
\usage{
plot_pie_valid_value(
  tbl = "dplyr::storms",
  col = "status",
  filter = "c()",
  negate = FALSE,
  missing_values = "'other low'",
  out = "ggplot2-cat",
  group_by = NULL
)
}
\arguments{
\item{tbl}{A character string or tibble specifying the input tibble}

\item{col}{A character string specifying a column of interest}

\item{filter}{A character string specifying the values to filter. (equivalent
to 'values in') This determines which values should be retained. It can be
applied to both grouped and ungrouped data.}

\item{negate}{If TRUE, return non-matching elements.}

\item{missing_values}{Vector listing values to exclude from valid values.
These values will not be excluded from counting - but will be displayed
separately from valid values.}

\item{out}{parameter that specifies the output expected: can be either
'ggplot2', 'plotly','ggplot2-code', 'plotly-code','ggplot2-cat' or
'plotly-cat'. ggplot2 renders a static plot, plotly a dynamic plot, code
gives the code in a string (usable directly with eval/parse functions) and
cat provides indented code in the console.}

\item{group_by}{A character string of one column in the tbl that can be
taken as a grouping column. The visual element will be grouped and displayed
by this column.}
}
\value{
A pie plot object
}
\description{
This function draws a pie plot of the values of a column separating valid,
non-valid and missing values.
Missing values can be given as input to non-valid and valid values
separately, or grouped by another column. The output can be editable (using
plotly library) or static (using ggplot2 library). The R-code is also
editable for coding recycling purpose.
}
\examples{
{

##### Example 1 -------------------------------------------------------------
# cat output generated as a template when no argument provided
plot_pie_valid_value()

##### Example 2 -------------------------------------------------------------
# graph of Species (virginica is as missing values)
plot_pie_valid_value(
  tbl = "dplyr::storms",
  col = "status",
  missing_values = "'other low'" ,
  out = "ggplot2")

}

}
\seealso{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
