% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{tidy.VAR}
\alias{tidy.VAR}
\title{Tidy a fable model}
\usage{
\method{tidy}{VAR}(x)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}
}
\value{
The model's coefficients in a \code{tibble}.
}
\description{
Returns the coefficients from the model in a \code{tibble} format.
}
\examples{
lung_deaths <- cbind(mdeaths, fdeaths) \%>\%
  as_tsibble(pivot_longer = FALSE)

lung_deaths \%>\%
  model(VAR(vars(mdeaths, fdeaths) ~ AR(3))) \%>\%
  tidy()
}
