% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hkmeans.R
\name{hkmeans}
\alias{hkmeans}
\alias{print.hkmeans}
\alias{hkmeans_tree}
\title{Hierarchical k-means clustering}
\usage{
hkmeans(x, k, hc.metric = "euclidean", hc.method = "ward.D2",
  iter.max = 10, km.algorithm = "Hartigan-Wong")

\method{print}{hkmeans}(x, ...)

hkmeans_tree(hkmeans, rect.col = NULL, ...)
}
\arguments{
\item{x}{a numeric matrix, data frame or vector}

\item{k}{the number of clusters to be generated}

\item{hc.metric}{the distance measure to be used. Possible values are "euclidean", "maximum", "manhattan", 
"canberra", "binary" or "minkowski" (see ?dist).}

\item{hc.method}{the agglomeration method to be used. Possible values include "ward.D", "ward.D2", "single", 
"complete", "average", "mcquitty", "median"or "centroid" (see ?hclust).}

\item{iter.max}{the maximum number of iterations allowed for k-means.}

\item{km.algorithm}{the algorithm to be used for kmeans (see ?kmeans).}

\item{...}{others arguments to be passed to the function plot.hclust(); (see ? plot.hclust)}

\item{hkmeans}{an object of class hkmeans (returned by the function hkmeans())}

\item{rect.col}{Vector with border colors for the rectangles around clusters in dendrogram}
}
\value{
hkmeans returns an object of class "hkmeans" containing the following components:
\itemize{
\item The elements returned by the standard function kmeans() (see ?kmeans)
\item data: the data used for the analysis
\item hclust: an object of class "hclust" generated by the function hclust()
}
}
\description{
The final k-means clustering solution is very sensitive to the initial random selection 
of cluster centers. This function provides a solution using an hybrid approach by combining 
the hierarchical clustering and the k-means methods. The procedure is explained in "Details" section. Read more:
  \href{http://www.sthda.com/english/wiki/hybrid-hierarchical-k-means-clustering-for-optimizing-clustering-outputs-unsupervised-machine-learning}{Hybrid hierarchical k-means clustering for optimizing clustering outputs}.
\itemize{
\item hkmeans(): compute hierarchical k-means clustering
\item print.hkmeans(): prints the result of hkmeans
\item hkmeans_tree(): plots the initial dendrogram
}
}
\details{
The procedure is as follow:   
     
1. Compute hierarchical clustering
   
2. Cut the tree in k-clusters
   
3. compute the center (i.e the mean) of each cluster
     
4. Do k-means by using the set of cluster centers (defined in step 3) as the initial cluster centers
}
\examples{
\donttest{
# Load data
data(USArrests)
# Scale the data
df <- scale(USArrests)

# Compute hierarchical k-means clustering
res.hk <-hkmeans(df, 4)

# Elements returned by hkmeans()
names(res.hk)

# Print the results
res.hk

# Visualize the tree
hkmeans_tree(res.hk, cex = 0.6)
# or use this
fviz_dend(res.hk, cex = 0.6)


# Visualize the hkmeans final clusters
fviz_cluster(res.hk, frame.type = "norm", frame.level = 0.68)
}
}
