% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness_regression_object.R
\name{plot.fairness_regression_object}
\alias{plot.fairness_regression_object}
\title{Plot fairness regression object}
\usage{
\method{plot}{fairness_regression_object}(x, ...)
}
\arguments{
\item{x}{\code{fairness_regression_object} object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Please note that this is experimental approach. Plot fairness check regression enables to look how big differences are between base subgroup (privileged) and unprivileged ones.
If bar plot reaches red zone it means that for this subgroup fairness goal is not satisfied. Multiple subgroups and models can be plotted.
Red and green zone boundary can be moved through epsilon parameter, that needs to be passed through \code{fairness_check}.
}
\examples{

set.seed(123)
data <- data.frame(x = c(rnorm(500, 500, 100), rnorm(500, 400, 200)),
                   pop = c(rep('A', 500 ), rep('B', 500 )))

data$y <- rnorm(length(data$x), 1.5 * data$x, 100)

# create model
model <- lm(y~., data = data)

# create explainer
exp <- DALEX::explain(model, data = data, y = data$y)

# create fobject
fobject <- fairness_check_regression(exp, protected = data$pop, privileged = 'A')

# results

fobject
plot(fobject)

\donttest{

model_ranger <- ranger::ranger(y~., data = data, seed = 123)
exp2 <- DALEX::explain(model_ranger, data = data, y = data$y)

fobject <- fairness_check_regression(exp2, fobject)

# results
fobject

plot(fobject)
}


}
