% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_metrics.R
\name{stack_metrics}
\alias{stack_metrics}
\title{Stack metrics}
\usage{
stack_metrics(x, fairness_metrics = c("ACC", "TPR", "PPV", "FPR", "STP"))
}
\arguments{
\item{x}{object of class \code{fairness_object}}

\item{fairness_metrics}{character, vector of fairness parity_loss metric names to include in plot. Full names are provided in \code{fairess_check} documentation.}
}
\value{
\code{stacked_metrics} object. It contains \code{data.frame} with information about score for each metric and model.
}
\description{
Stack metrics sums parity loss metrics for all models. Higher value of stacked metrics means the model is less fair (has higher bias)
for subgroups from protected vector.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) - 1

lm_model <- glm(Risk ~ .,
  data = german,
  family = binomial(link = "logit")
)


explainer_lm <- DALEX::explain(lm_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
  protected = german$Sex,
  privileged = "male"
)

sm <- stack_metrics(fobject)
plot(sm)
\donttest{

rf_model <- ranger::ranger(Risk ~ .,
  data = german,
  probability = TRUE,
  num.trees = 200
)

explainer_rf <- DALEX::explain(rf_model, data = german[, -1], y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)

sm <- stack_metrics(fobject)
plot(sm)
}

}
