% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataParameterChecks.R
\name{.check_survival_time_plausibility}
\alias{.check_survival_time_plausibility}
\title{Internal function to test plausibility of provided survival times.}
\usage{
.check_survival_time_plausibility(
  data,
  outcome_type,
  outcome_column,
  check_stringency = "strict"
)
}
\arguments{
\item{data}{Data set as loaded using the \code{.load_data} function.}

\item{outcome_type}{(\strong{recommended}) Type of outcome found in the outcome
column. The outcome type determines many aspects of the overall process,
e.g. the available feature selection methods and learners, but also the
type of assessments that can be conducted to evaluate the resulting models.
Implemented outcome types are:
\itemize{
\item \code{binomial}: categorical outcome with 2 levels.
\item \code{multinomial}: categorical outcome with 2 or more levels.
\item \code{count}: Poisson-distributed numeric outcomes.
\item \code{continuous}: general continuous numeric outcomes.
\item \code{survival}: survival outcome for time-to-event data.
}

If not provided, the algorithm will attempt to obtain outcome_type from
contents of the outcome column. This may lead to unexpected results, and we
therefore advise to provide this information manually.

Note that \code{competing_risk} survival analysis are not fully supported, and
is currently not a valid choice for \code{outcome_type}.}

\item{outcome_column}{(\strong{recommended}) Name of the column containing the
outcome of interest. May be identified from a formula, if a formula is
provided as an argument. Otherwise an error is raised. Note that \code{survival}
and \code{competing_risk} outcome type outcomes require two columns that
indicate the time-to-event or the time of last follow-up and the event
status.}
}
\description{
This function checks whether non-positive outcome time is present in the
data. This may produce unexpected results for some packages. For example,
glmnet will not train if an instance has a survival time of 0 or lower.
}
\keyword{internal}
