% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotUtilities.R
\name{plotting.check_data_handling}
\alias{plotting.check_data_handling}
\title{Checks and sanitizes spliting variables for plotting.}
\usage{
plotting.check_data_handling(
  x,
  split_by = NULL,
  color_by = NULL,
  linetype_by = NULL,
  facet_by = NULL,
  x_axis_by = NULL,
  y_axis_by = NULL,
  available = NULL
)
}
\arguments{
\item{x}{data.table or data.frame containing the data used for splitting.}

\item{split_by}{(\emph{optional}) Splitting variables. This refers to column names
on which datasets are split. A separate figure is created for each split.
See details for available variables.}

\item{color_by}{(\emph{optional}) Variables used to determine fill colour of plot
objects. The variables cannot overlap with those provided to the \code{split_by}
argument, but may overlap with other arguments. See details for available
variables.}

\item{linetype_by}{(\emph{optional}) Variables that are used to determine the
linetype of lines in a plot. The variables cannot overlap with those
provided to the \code{split_by} argument, but may overlap with other arguments.
Sett details for available variables.}

\item{facet_by}{(\emph{optional}) Variables used to determine how and if facets of
each figure appear. In case the \code{facet_wrap_cols} argument is \code{NULL}, the
first variable is used to define columns, and the remaing variables are
used to define rows of facets. The variables cannot overlap with those
provided to the \code{split_by} argument, but may overlap with other arguments.
See details for available variables.}

\item{x_axis_by}{(\emph{optional}) Variable plotted along the x-axis of a plot.
The variable cannot overlap with variables provided to the \code{split_by} and
\code{y_axis_by} arguments (if used), but may overlap with other arguments. Only
one variable is allowed for this argument. See details for available
variables.}

\item{y_axis_by}{(\emph{optional}) Variable plotted along the y-axis of a plot.
The variable cannot overlap with variables provided to the \code{split_by} and
\code{x_axis_by} arguments (if used), but may overlap with other arguments. Only
one variable is allowed for this argument. See details for available
variables.}

\item{available}{Names of columns available for splitting.}
}
\value{
A sanitized list of splitting variables.
}
\description{
Checks and sanitizes spliting variables for plotting.
}
\details{
This internal function allows some flexibility regarding the exact
input. Allowed splitting variables should be defined by the available
argument.
}
\keyword{internal}
