% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_loss.R
\name{compute_loss}
\alias{compute_loss}
\title{Compute the FARO Loss Between Feature Allocations}
\usage{
compute_loss(Z1, Z2, a = 1, augmented = FALSE)
}
\arguments{
\item{Z1}{A feature allocation in binary matrix form, with items in the rows
and features in the columns.}

\item{Z2}{A feature allocation in binary matrix form, with items in the rows
and features in the columns.}

\item{a}{A numeric scalar for the cost parameter of generalized Hamming
distance used in FARO loss.  The other cost parameter, \eqn{b}, is equal to
\eqn{2 - a}.}

\item{augmented}{If \code{TRUE}, the column permutation (used by FARO loss to
compare the feature allocations) is returned for each matrix.}
}
\value{
The FARO loss as a scalar value if \code{augmented = FALSE}, otherwise, a list
of 3 elements including the loss and the two column permutations.
}
\description{
The FARO loss is computed between two feature allocations, each represented
in binary matrix form.
}
\examples{
Z1 <- matrix(c(0,1,1,0,1,1,0,1,1,1,1,1), byrow=TRUE, nrow=6)
Z2 <- matrix(c(0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0), byrow=TRUE, nrow=6)
compute_loss(Z1,Z2)
x <- compute_loss(Z1,Z2,a=1,TRUE)
sum(cbind(Z1,0) != Z2)
sum(cbind(Z1,0)[,x$permutation1] != Z2)
sum(cbind(Z1,0) != Z2[,x$permutation2])

}
