% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strsplit.R
\name{strsplit_ctl}
\alias{strsplit_ctl}
\title{ANSI Control Sequence Aware Version of strsplit}
\usage{
strsplit_ctl(x, split, fixed = FALSE, perl = FALSE, useBytes = FALSE,
  warn = getOption("fansi.warn"), term.cap = getOption("fansi.term.cap"))
}
\arguments{
\item{x}{a character vector, or, unlike \link[base:strsplit]{base::strsplit} an object that can
be coerced to character.}

\item{split}{
    character vector (or object which can be coerced to such)
    containing \link{regular expression}(s) (unless \code{fixed = TRUE})
    to use for splitting.  If empty matches occur, in particular if
    \code{split} has length 0, \code{x} is split into single characters.
    If \code{split} has length greater than 1, it is re-cycled along
    \code{x}.
  }

\item{fixed}{
    logical.  If \code{TRUE} match \code{split} exactly, otherwise
    use regular expressions.  Has priority over \code{perl}.
  }

\item{perl}{logical.  Should Perl-compatible regexps be used?}

\item{useBytes}{logical.  If \code{TRUE} the matching is done
    byte-by-byte rather than character-by-character, and inputs with
    marked encodings are not converted.  This is forced (with a warning)
    if any input is found which is marked as \code{"bytes"}
    (see \code{\link{Encoding}}).}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{term.cap}{character a vector of the capabilities of the terminal, can
be any combination "bright" (SGR codes 90-97, 100-107), "256" (SGR codes
starting with "38;5" or "48;5"), and "truecolor" (SGR codes starting with
"38;2" or "48;2"). Changing this parameter changes how \code{fansi} interprets
escape sequences, so you should ensure that it matches your terminal
capabilities. See \link{term_cap_test} for details.}
}
\value{
list, see \link[base:strsplit]{base::strsplit}.
}
\description{
A drop-in replacement for \link[base:strsplit]{base::strsplit}.  It will be noticeably slower,
but should otherwise behave the same way except for CSI SGR sequence
awareness.
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.  The
split positions are computed after both \code{x} and \code{split} are converted to
UTF-8.
}
\examples{
strsplit_ctl("\\033[31mhello\\033[42m world!", " ")
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results,
\link[base:strsplit]{base::strsplit} for details on the splitting.
}
