% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nchar.R
\name{nchar_ctl}
\alias{nchar_ctl}
\alias{nzchar_ctl}
\title{ANSI Control Sequence Aware Version of nchar}
\usage{
nchar_ctl(x, type = "chars", allowNA = FALSE, keepNA = NA,
  strip = "all", warn = getOption("fansi.warn"))

nzchar_ctl(x, keepNA = NA, warn = getOption("fansi.warn"))
}
\arguments{
\item{x}{a character vector or object that can be coerced to character.}

\item{type}{character string, one of "chars", or "width".  For byte counts
use \link[base:nchar]{base::nchar}.}

\item{allowNA}{logical: should \code{NA} be returned for invalid
    multibyte strings or \code{"bytes"}-encoded strings (rather than
    throwing an error)?}

\item{keepNA}{logical: should \code{NA} be returned where ever
  \code{x} is \code{\link{NA}}?  If false, \code{nchar()} returns
  \code{2}, as that is the number of printing characters used when
  strings are written to output, and \code{nzchar()} is \code{TRUE}.  The
  default for \code{nchar()}, \code{NA}, means to use \code{keepNA = TRUE}
  unless \code{type} is \code{"width"}.  Used to be (implicitly) hard
  coded to \code{FALSE} in \R versions \eqn{\le}{<=} 3.2.0.}

\item{strip}{character, any combination of the following values (see details):
\itemize{
\item "nl": strip newlines.
\item "c0": strip all other "C0" control characters (i.e. x01-x1f), except for
newlines and the actual ESC character.
\item "sgr": strip ANSI CSI SGR sequences.
\item "csi": strip all non-SGR csi sequences.
\item "esc": strip all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but" (see details).
}}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}
}
\description{
\code{nchar_ctl} counts all non \emph{Control Sequence} characters.
\code{nzchar_ctl} returns TRUE for each input vector element that has non \emph{Control
Sequence} sequence characters.  By default newlines and other C0 control
characters are not counted.
}
\details{
\code{nchar_ctl} is just a wrapper around \code{nchar(strip_ctl(...))}.  \code{nzchar_ctl}
is implemented in native code and is much faster than the otherwise
equivalent \code{nzchar(strip_ctl(...))}.  You cannot change which \emph{Control
Sequences} count in \code{nzchar_ctl}, but you can always resort to
\code{nzchar(strip_ctl(..., strip='...'))} if that is important.

These functions will warn if either malformed or non-CSI escape sequences are
encountered, as these may be incorrectly interpreted.
}
\note{
the \code{keepNA} parameter is ignored for R < 3.2.
}
\examples{
nchar_ctl("\\033[31m123\\a\\r")
## with some wide characters
cn.string <-  sprintf("\\033[31m\%s\\a\\r", "\\u4E00\\u4E01\\u4E03")
nchar_ctl(cn.string)
nchar_ctl(cn.string, type='width')

## Remember newlines are not counted by default
nchar_ctl("\\t\\n\\r")

## The 'c0' value for the `strip` argument does
## not include newlines.
nchar_ctl("\\t\\n\\r", strip="c0")
nchar_ctl("\\t\\n\\r", strip=c("c0", "nl"))

## All of the following are Control Sequences
nzchar_ctl("\\n\\033[42;31m\\033[123P\\a")
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results,
\link{strip_ctl} for removing \emph{Control Sequences}.
}
