/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.BadModelException;
import jfm.model.Crop;
import jfm.model.CroppingComponent;
import jfm.model.Types;

public class VARRiskComponent
extends ModelComponent {
    private MatrixVariable riskVar = null;
    private double alpha = 0.0;
    private double offset = 0.0;

    public VARRiskComponent(double alpha_, double offset_) {
        super(ModelComponent.MCType.VARRISK);
        this.requireObjective(Types.ObjectiveType.VARRISK);
        this.addConstraintBuilder(new VARRiskValueConstraint());
        this.alpha = alpha_;
        this.offset = offset_;
    }

    public ModelComponent copy() {
        return null;
    }

    protected void initializeStructure() throws BadModelException {
        MatrixVariable newVariable = new MatrixVariable(1.0, 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.VARRISK);
        newVariable.setTag("varrisk");
        this.riskVar = newVariable;
        this.matrix.addVariable(newVariable);
    }

    protected String name() {
        return "VarRisk";
    }

    public void setFormulaVariables() {
    }

    protected void updateStructure() {
    }

    public final class VARRiskValueConstraint
    extends ConstraintBuilder {
        public VARRiskValueConstraint() {
            super(ConstraintBuilder.CBType.VARRISKVALUE, ModelComponent.MCType.VARRISK);
        }

        protected void build() {
            int row = VARRiskComponent.this.matrix.numRows();
            CroppingComponent cropping = VARRiskComponent.this.getParent().cropping;
            MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, "VARRiskValue", this.type().tag);
            VARRiskComponent.this.matrix.addRow(rowpointer);
            ++row;
            rowpointer.addElement(new MatrixElement(VARRiskComponent.this.riskVar.column(), 1.0));
            for (Crop cp : cropping.getCrops().values()) {
                for (Crop.CropCopy cpp : cp.getYearCopies()) {
                    rowpointer.addElement(new MatrixElement(cpp.getDependentColumn(0), -1.0 * Math.abs(cpp.getVARRisk(VARRiskComponent.this.alpha, VARRiskComponent.this.offset))));
                }
            }
        }
    }
}

