/*
 * Decompiled with CFR 0.152.
 */
package jfm.r;

import jfm.lp.LPX;
import jfm.model.Crop;
import jfm.model.CropInput;
import jfm.model.Farm;
import jfm.model.Limit;
import jfm.model.Location;
import jfm.model.Output;
import jfm.model.Types;
import jfm.mou.FarmerMOU;
import jfm.r.FarmRepresentation;
import jfm.xml.XMLSyntaxException;
import org.w3c.dom.Document;

public class SimpleFarmRepresentation
extends FarmRepresentation {
    protected final Farm farmObject;

    public SimpleFarmRepresentation(String xmlFileName) {
        this.farmObject = Farm.fromXML(xmlFileName);
    }

    public SimpleFarmRepresentation(Document doc) {
        this.farmObject = Farm.fromXML(doc);
    }

    public String solver() {
        return this.farmObject.solver();
    }

    public void setYieldForCrop(String xmlCropName, double yield) {
        try {
            Crop cp = this.farmObject.cropping.getCrop(Types.xmlToCropType(xmlCropName));
            cp.resetPrimaryYield(String.valueOf(yield));
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
    }

    public void setPriceForCrop(String xmlCropName, double price) {
        try {
            Crop cp = this.farmObject.cropping.getCrop(Types.xmlToCropType(xmlCropName));
            cp.resetPrimaryPrice(price);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
    }

    public void setSubsidyForCrop(String xmlCropName, double subsidy) {
        try {
            Crop cp = this.farmObject.cropping.getCrop(Types.xmlToCropType(xmlCropName));
            cp.resetSubsidy(subsidy);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
    }

    public void setInputCost(String xmlInputName, double unitCost) {
        try {
            Types.VariableType vt = Types.xmlToVariableType(xmlInputName);
            for (Types.CropType ct : this.farmObject.cropping.baseCropTypes()) {
                Crop cp = this.farmObject.cropping.getCrop(ct);
                cp.resetInputCost(vt, unitCost);
            }
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
    }

    public void setFarmArea(double area) {
        this.farmObject.landUse.setArea(area);
    }

    public void applyMOU(FarmerMOU mou) {
        FarmerMOU.applyToFarm(mou, this.farmObject);
    }

    public void createAndApplyMOU(String mouName) {
        FarmerMOU mou = FarmerMOU.fromXML(mouName);
        this.applyMOU(mou);
    }

    public void createAndApplyMOU(Document doc) {
        FarmerMOU mou = FarmerMOU.fromXML(doc);
        this.applyMOU(mou);
    }

    public String solutionSummary() {
        if (this.isSolved() == 0) {
            StringBuffer buff = new StringBuffer();
            buff.append("Unsolved Simple Farm \n Crops \n \n");
            String[] cnames = this.cropNames();
            for (int i = 0; i < cnames.length; ++i) {
                buff.append(cnames[i] + " ");
            }
            return buff.toString();
        }
        return Output.solution(this.farmObject, false);
    }

    public void solutionDetails() {
        System.out.println(Output.solution(this.farmObject, true));
    }

    public double profit() {
        return this.farmObject.getValueForObjective(Types.ObjectiveType.PROFIT);
    }

    public double eo() {
        return this.farmObject.getEnterpriseOutput();
    }

    public void setSoilTypeAndRainfall(double st, double rf) {
        this.farmObject.setLocation(new Location(st, rf, this.farmObject.numPeriods));
    }

    public void fixAreaOfCrop(double areaLimit, String xmlCropName) {
        try {
            Types.CropType cptype = Types.xmlToCropType(xmlCropName);
            Limit cpLimit = Limit.CropAreaLimit(cptype, LPX.LPX_FX, areaLimit, areaLimit);
            this.farmObject.cropping.addLimit(cpLimit);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
    }

    public void lowerLimitAreaOfCrop(double areaLimit, String xmlCropName) {
        try {
            Types.CropType cptype = Types.xmlToCropType(xmlCropName);
            Limit cpLimit = Limit.CropAreaLimit(cptype, LPX.LPX_LO, areaLimit, areaLimit);
            this.farmObject.cropping.addLimit(cpLimit);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
    }

    public void boundLimitAreaOfCrop(double areaMin, double areaMax, String xmlCropName) {
        try {
            Types.CropType cptype = Types.xmlToCropType(xmlCropName);
            Limit cpLimit = Limit.CropAreaLimit(cptype, LPX.LPX_DB, areaMin, areaMax);
            this.farmObject.cropping.addLimit(cpLimit);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
    }

    public void reset() {
        this.farmObject.cropping.clearLimits();
    }

    public String[] cropNames() {
        String[] names = new String[this.farmObject.cropping.baseCropTypes().size()];
        int i = 0;
        for (Types.CropType ct : this.farmObject.cropping.baseCropTypes()) {
            names[i] = ct.xmlname;
            ++i;
        }
        return names;
    }

    public String[] objectiveNames() {
        String[] names = new String[this.farmObject.objectives().keySet().size()];
        int i = 0;
        for (Types.ObjectiveType ot : this.farmObject.sortedObjectiveTypes()) {
            names[i] = ot.xmlname;
            ++i;
        }
        return names;
    }

    public double[] objectiveValues() {
        double[] values = new double[this.farmObject.objectives().keySet().size()];
        int i = 0;
        for (Types.ObjectiveType ot : this.farmObject.sortedObjectiveTypes()) {
            values[i] = this.farmObject.getValueForObjective(ot);
            ++i;
        }
        return values;
    }

    public double[] objectiveScaleFactors() {
        double[] values = new double[this.farmObject.objectives().keySet().size()];
        int i = 0;
        for (Types.ObjectiveType ot : this.farmObject.sortedObjectiveTypes()) {
            values[i] = this.farmObject.objectives().get((Object)ot).scaleFactor();
            ++i;
        }
        return values;
    }

    public double areaOfCropNamed(String name) {
        Types.CropType ct = null;
        try {
            ct = Types.xmlToCropType(name);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
        if (this.farmObject.cropping.baseCropTypes().contains((Object)ct)) {
            return this.farmObject.cropping.getCrop(ct).getSolvedArea();
        }
        return 0.0;
    }

    public double priceOfCropNamed(String name) {
        Types.CropType ct = null;
        try {
            ct = Types.xmlToCropType(name);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
        if (this.farmObject.cropping.baseCropTypes().contains((Object)ct)) {
            return this.farmObject.cropping.getCrop(ct).getPrimaryPrice();
        }
        return 0.0;
    }

    public double yieldOfCropNamed(String name) {
        Types.CropType ct = null;
        try {
            ct = Types.xmlToCropType(name);
        }
        catch (XMLSyntaxException ex) {
            throw new Error(ex.getMessage());
        }
        if (this.farmObject.cropping.baseCropTypes().contains((Object)ct)) {
            return this.farmObject.cropping.getCrop(ct).getPrimaryYield();
        }
        return 0.0;
    }

    public double areaOfWinterStubble() {
        return this.farmObject.getValueForObjective(Types.ObjectiveType.WINTERSTUBBLE);
    }

    public int isSolved() {
        if (this.farmObject.solutionStatus() == LPX.LPX_OPT) {
            return 1;
        }
        return 0;
    }

    public void setDistanceFromSugarbeetFactory(double distance, double costPerKmPerHa) {
        if (this.farmObject.cropping.baseCropTypes().contains((Object)Types.CropType.SUGARBEET)) {
            Crop cp = this.farmObject.cropping.getCrop(Types.CropType.SUGARBEET);
            double[] amounts = new double[]{distance};
            CropInput inp = new CropInput(amounts, costPerKmPerHa, Types.VariableType.TRANSPORT);
            cp.resetInput(Types.VariableType.TRANSPORT, inp);
        }
    }

    public int solve(String failDump) {
        try {
            LPX status = this.farmObject.solve(true, failDump);
            return status.toCPP();
        }
        catch (Exception ex) {
            throw new Error(ex.getCause() + " " + ex.getMessage());
        }
    }

    public String toString() {
        return this.farmObject.toString();
    }
}

