/*
 * Decompiled with CFR 0.152.
 */
package jfm.r;

import java.util.ArrayList;
import jfm.r.DocumentEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FarmDocumentEditor {
    public static String dump(Document doc) {
        return DocumentEditor.printNode(doc, " ");
    }

    public static String[] cropNames(Document doc) {
        NodeList crops = doc.getElementsByTagName("crop");
        String[] names = new String[crops.getLength()];
        for (int n = 0; n < crops.getLength(); ++n) {
            Node crop = crops.item(n);
            int idAtt = DocumentEditor.findAttribute(crop, "id");
            if (idAtt == -1) {
                throw new Error("id attribute not defined for crop node");
            }
            names[n] = crop.getAttributes().item(idAtt).getNodeValue();
        }
        return names;
    }

    public static Node getNodeForCropAttribute(Document doc, String cropName, String attName) {
        NodeList crops = doc.getElementsByTagName("crop");
        for (int n = 0; n < crops.getLength(); ++n) {
            Node crop = crops.item(n);
            int idAtt = DocumentEditor.findAttribute(crop, "id");
            if (idAtt == -1) {
                throw new Error("id attribute not defined for crop node");
            }
            if (!crop.getAttributes().item(idAtt).getNodeValue().equals(cropName)) continue;
            int attId = DocumentEditor.findAttribute(crop, attName);
            if (attId == -1) {
                throw new Error("No attribute " + attName + " defined for crop");
            }
            return crop.getAttributes().item(attId);
        }
        throw new Error("No crop named " + cropName);
    }

    public static ArrayList<Node> getNodesForAttributeOfTagFilteredByAttribute(Document doc, String tagName, String filterAttribute, String filterAttributeValue, String attName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList tags = doc.getElementsByTagName(tagName);
        for (int n = 0; n < tags.getLength(); ++n) {
            int updatedAttId;
            Node tag = tags.item(n);
            int attId = DocumentEditor.findAttribute(tag, filterAttribute);
            if (attId == -1 && !filterAttribute.equals("nil") || !filterAttribute.equals("nil") && !tag.getAttributes().item(attId).getNodeValue().equals(filterAttributeValue) || (updatedAttId = DocumentEditor.findAttribute(tag, attName)) == -1) continue;
            nodes.add(tag.getAttributes().item(updatedAttId));
        }
        return nodes;
    }

    public static Document setRelativeAttributeOfTagFilteredByAttribute(Document doc, String tagName, double multiplier, String filterAttribute, String filterAttributeValue, String attName) {
        ArrayList<Node> nodes = FarmDocumentEditor.getNodesForAttributeOfTagFilteredByAttribute(doc, tagName, filterAttribute, filterAttributeValue, attName);
        for (Node n : nodes) {
            double oldval = Double.parseDouble(n.getNodeValue());
            n.setNodeValue(Double.toString(multiplier * oldval));
        }
        return doc;
    }

    public static String[] getAttributesOfTagFilteredByAttribute(Document doc, String tagName, String filterAttribute, String filterAttributeValue, String attName) {
        ArrayList<Node> nodes = FarmDocumentEditor.getNodesForAttributeOfTagFilteredByAttribute(doc, tagName, filterAttribute, filterAttributeValue, attName);
        int i = 0;
        String[] attributes = new String[nodes.size()];
        for (Node n : nodes) {
            attributes[i] = n.getNodeValue();
            ++i;
        }
        return attributes;
    }

    public static Document setAttributeOfTagFilteredByAttribute(Document doc, String tagName, String newValue, String filterAttribute, String filterAttributeValue, String attName) {
        ArrayList<Node> nodes = FarmDocumentEditor.getNodesForAttributeOfTagFilteredByAttribute(doc, tagName, filterAttribute, filterAttributeValue, attName);
        for (Node n : nodes) {
            n.setNodeValue(newValue);
        }
        return doc;
    }

    public static Document setRelativeWorkrateFormulas(Document doc, double multiplier) {
        NodeList tags = doc.getElementsByTagName("csv");
        for (int n = 0; n < tags.getLength(); ++n) {
            Node csvNode = tags.item(n);
            int attId = DocumentEditor.findAttribute(csvNode, "data");
            if (attId == -1 || !csvNode.getAttributes().item(attId).getNodeValue().equals("wkrate")) continue;
            String oldval = csvNode.getChildNodes().item(0).getNodeValue();
            csvNode.getChildNodes().item(0).setNodeValue("(" + Double.toString(multiplier) + "*" + "(" + oldval + "))");
        }
        return doc;
    }

    public static Document setRelativeRotationPenalties(Document doc, double multiplier) {
        ArrayList<Node> nodes = FarmDocumentEditor.getNodesForAttributeOfTagFilteredByAttribute(doc, "crop", "nil", "nil", "yieldReduction");
        nodes.addAll(FarmDocumentEditor.getNodesForAttributeOfTagFilteredByAttribute(doc, "crop", "nil", "nil", "selfRotCost"));
        for (Node n : nodes) {
            String csvtext = n.getNodeValue();
            String[] csvitems = csvtext.split(",");
            StringBuffer newcsvText = new StringBuffer();
            newcsvText.append(String.valueOf(Double.parseDouble(csvitems[0]) * multiplier));
            for (int i = 1; i < csvitems.length; ++i) {
                newcsvText.append("," + String.valueOf(Double.parseDouble(csvitems[i]) * multiplier));
            }
            n.setNodeValue(newcsvText.toString());
        }
        return doc;
    }

    public static Document setAttributeForCrop(Document doc, double newValue, String cropName, String attName) {
        Node n = FarmDocumentEditor.getNodeForCropAttribute(doc, cropName, attName);
        n.setNodeValue(Double.toString(newValue));
        return doc;
    }

    public static Document setStringAttributeForCrop(Document doc, String newValue, String cropName, String attName) {
        Node n = FarmDocumentEditor.getNodeForCropAttribute(doc, cropName, attName);
        n.setNodeValue(newValue);
        return doc;
    }

    public static double getDoubleAttributeForCrop(Document doc, String cropName, String attName) {
        Node n = FarmDocumentEditor.getNodeForCropAttribute(doc, cropName, attName);
        return Double.parseDouble(n.getNodeValue());
    }

    public static String getStringAttributeForCrop(Document doc, String cropName, String attName) {
        Node n = FarmDocumentEditor.getNodeForCropAttribute(doc, cropName, attName);
        return n.getNodeValue();
    }

    public static Document setRelativePriceForCrop(Document doc, double priceChange, String cropName) {
        double oldPrice = FarmDocumentEditor.getDoubleAttributeForCrop(doc, cropName, "price");
        return FarmDocumentEditor.setAttributeForCrop(doc, oldPrice * priceChange, cropName, "price");
    }

    public static Document setMultiplierOnYieldFormulaForCrop(Document doc, double priceChange, String cropName) {
        String form = FarmDocumentEditor.getStringAttributeForCrop(doc, cropName, "yield");
        form = "(" + String.valueOf(priceChange) + "*" + form + ")";
        FarmDocumentEditor.setStringAttributeForCrop(doc, form, cropName, "yield");
        return doc;
    }

    public static Document setPriceForCrop(Document doc, double newPrice, String cropName) {
        return FarmDocumentEditor.setAttributeForCrop(doc, newPrice, cropName, "price");
    }

    public static Document setSubsidyForCrop(Document doc, double newSubsidy, String cropName) {
        return FarmDocumentEditor.setAttributeForCrop(doc, newSubsidy, cropName, "subsidy");
    }
}

