/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jfm.model.Location;
import jfm.model.Types;
import jfm.xml.XMLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextConverter {
    private static Pattern workerPattern = Pattern.compile("(\\w*\\-?\\w*)\\s*(\\d+)?");
    private static Pattern datePattern = Pattern.compile("(\\d)\\s*:\\s*(\\w{3})\\s*(\\d+)");

    public static double[] toDouble(String[] vals) throws XMLSyntaxException {
        double[] rvals = new double[vals.length];
        try {
            for (int i = 0; i < vals.length; ++i) {
                rvals[i] = Double.parseDouble(vals[i]);
            }
        }
        catch (NumberFormatException ex) {
            throw new XMLSyntaxException("Bad double format ");
        }
        return rvals;
    }

    public static double[][] toDouble(String[] vals, int size) throws XMLSyntaxException {
        if (size * size != vals.length) {
            throw new XMLSyntaxException("Attempt to convert strings to square matrix but incorrect number of elements " + vals.length + " for matrix " + size + "x" + size);
        }
        double[][] rvals = new double[size][size];
        try {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    rvals[i][j] = Double.parseDouble(vals[i * size + j]);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new XMLSyntaxException("Bad double format ");
        }
        return rvals;
    }

    public static int[] toInt(String[] vals) throws XMLSyntaxException {
        int[] rvals = new int[vals.length];
        try {
            for (int i = 0; i < vals.length; ++i) {
                rvals[i] = Integer.parseInt(vals[i]);
            }
        }
        catch (NumberFormatException ex) {
            throw new XMLSyntaxException("Bad integer format ");
        }
        return rvals;
    }

    public static Map<Types.WorkerType, Integer> toNumMachines(String[] vals) throws XMLSyntaxException {
        LinkedHashMap<Types.WorkerType, Integer> nmach = new LinkedHashMap<Types.WorkerType, Integer>();
        try {
            for (int w = 0; w < vals.length; ++w) {
                Types.WorkerType wtype;
                int num;
                Matcher wkmatch = workerPattern.matcher(vals[w]);
                if (wkmatch.find()) {
                    num = 1;
                    wtype = Types.xmlToWorkerType(wkmatch.group(1));
                    if (wkmatch.group(2) != null) {
                        num = Integer.parseInt(wkmatch.group(2));
                    }
                } else {
                    throw new XMLSyntaxException("Not a valid format for wktype ");
                }
                nmach.put(wtype, num);
            }
        }
        catch (XMLSyntaxException tex) {
            tex.printStackTrace();
            throw new XMLSyntaxException(tex.getMessage());
        }
        return nmach;
    }

    public static int[] toPeriods(String[] fromto, int numPeriods) throws XMLSyntaxException {
        if (fromto.length != 2) {
            throw new XMLSyntaxException("periods should be specified as exactly 2 comma separated fields  but " + fromto.length + " specified ");
        }
        Matcher from = datePattern.matcher(fromto[0]);
        Matcher to = datePattern.matcher(fromto[1]);
        if (from.find() && to.find() && from.groupCount() == 3 && to.groupCount() == 3) {
            int[] periods;
            if (Location.month.get(from.group(2)) == null) {
                throw new XMLSyntaxException("Incorrect month specification in from field ");
            }
            int fromyr = Integer.parseInt(from.group(1)) - 1;
            GregorianCalendar fromdate = new GregorianCalendar(2000 + fromyr, Location.month.get(from.group(2)), Integer.parseInt(from.group(3)), 0, 0);
            int fromperiod = Location.getWFMPeriod(fromdate, numPeriods);
            if (Location.month.get(to.group(2)) == null) {
                throw new XMLSyntaxException("Incorrect month specification in to field ");
            }
            int toyr = Integer.parseInt(to.group(1)) - 1;
            GregorianCalendar todate = new GregorianCalendar(2000 + toyr, Location.month.get(to.group(2)), Integer.parseInt(to.group(3)), 0, 0);
            int toperiod = Location.getWFMPeriod(todate, numPeriods);
            int pwidth = toperiod - fromperiod;
            if (pwidth == 0) {
                pwidth = 1;
            }
            if (pwidth > 0) {
                periods = new int[pwidth];
                for (int i = 0; i < pwidth; ++i) {
                    periods[i] = fromperiod + i;
                }
            } else {
                throw new XMLSyntaxException("from date must be before to date" + fromto[0] + " " + fromperiod + " to " + fromto[1] + " " + toperiod);
            }
            return periods;
        }
        throw new XMLSyntaxException("Failed to parse dates ");
    }
}

