% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilson.ci.R
\name{wilson.ci}
\alias{wald.ci}
\alias{wilson.ci}
\title{Confidence Intervals for Proportions}
\usage{
wilson.ci(x, n = 100, conf.level = 0.95)
}
\arguments{
\item{x}{number of 'successes'}

\item{n}{number of trials}

\item{conf.level}{confidence level}
}
\value{
Lower and upper bounds of a two-sided confidence interval.
}
\description{
Alternatives to \code{prop.test} and \code{binom.test}.
}
\details{
\code{wald.ci} produces Wald confidence intervals. \code{wilson.ci}
produces Wilson confidence intervals (also called ``plus-4'' confidence
intervals) which are Wald intervals computed from data formed by adding 2
successes and 2 failures.  The Wilson confidence intervals have better
coverage rates for small samples.
}
\examples{

prop.test(12,30)
prop.test(12,30, correct=FALSE)
wald.ci(12,30)
wilson.ci(12,30)
wald.ci(12+2,30+4)

}
\author{
Randall Pruim
}
\references{
A. Agresti and B. A. Coull, Approximate is better then `exact'
for interval estimation of binomial proportions, \emph{American
Statistician} 52 (1998), 119--126.
}

