% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Endurance}
\alias{Endurance}
\title{Endurance and vitamin C}
\format{
A data frame with 15 observations on the following 5 variables.
\describe{ 
\item{vitamin}{ number of repetitions until reaching 50%
maximal grip after taking viatimin} 
\item{first}{ which treatment was
done first, a factor with levels \code{Placebo} \code{Vitamin}}
\item{placebo}{ number of repetitions until reaching 50% maximal grip
strength after taking placebo} }
}
\source{
These data are available from OzDASL, the Australasian data and
story library (\url{https://dasl.datadescription.com/}).
}
\description{
The effect of a single 600 mg dose of ascorbic acid versus a sugar placebo
on the muscular endurance (as measured by repetitive grip strength trials)
of fifteen male volunteers (19-23 years old).
}
\details{
Three initial maximal contractions were performed for each subject, with the
greatest value indicating maximal grip strength. Muscular endurance was
measured by having the subjects squeeze the dynamometer, hold the
contraction for three seconds, and repeat continuously until a value of 50%
maximum grip strength was achieved for three consecutive contractions.
Endurance was defined as the number of repetitions required to go from
maximum grip strength to the initial 50% value. Subjects were given frequent
positive verbal encouragement in an effort to have them complete as many
repetitions as possible.

The study was conducted in a double-blind manner with crossover.
}
\examples{

data(Endurance)
t.test(Endurance$vitamin, Endurance$placebo, paired = TRUE)
t.test(log(Endurance$vitamin), log(Endurance$placebo), paired = TRUE)
t.test(1/Endurance$vitamin, 1/Endurance$placebo, paired = TRUE)
gf_qq( ~ vitamin - placebo, data = Endurance)
gf_qq( ~ log(vitamin) - log(placebo), data = Endurance)
gf_qq( ~ 1/vitamin - 1/placebo, data = Endurance)

}
\references{
Keith, R. E., and Merrill, E. (1983).  The effects of vitamin C
on maximum grip strength and muscular endurance.  \emph{Journal of Sports
Medicine and Physical Fitness}, 23, 253-256.
}
\keyword{datasets}
