% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasim.R
\name{simulate_toy_gene_data}
\alias{simulate_toy_gene_data}
\title{Simulate Toy Gene Expression Data}
\usage{
simulate_toy_gene_data(n, m, k, s)
}
\arguments{
\item{n}{The number of samples (gene expression profiles) to
simulate.}

\item{m}{The number of counts (genes) to simulate.}

\item{k}{The number of topics ("gene programs") used to simulate
the data.}

\item{s}{A scalar specifying the total expression of each sample;
it specifies the "size" parameter in the calls to
\code{\link[stats]{rmultinom}}.}
}
\value{
The return value is a list containing the counts matrix
  \code{X}, and the gene frequencies \code{F} and mixture proportions
  \code{L} used to generate the counts.
}
\description{
Simulate gene expression data (UMI counts) under a
  toy expression model. Samples (expression profiles) are drawn
  from a multinomial topic model in which topics are "gene programs".
}
\details{
The mixture proportions are generated as follows. With
probability 0.9, one proportion is one, or close to one, and the
remaining are zero, or close to zero; that is, the counts are
primarily generated from a single gene program. Otherwise (wtth
probability 0.1), the mixture proportions are roughly equal.

Gene frequencies are drawn uniformly at random from [0,1].
}
