% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_ar}
\alias{fastcpd_ar}
\alias{fastcpd.ar}
\title{Find change points efficiently in AR(\eqn{p}) models}
\usage{
fastcpd_ar(data, order = 0, ...)

fastcpd.ar(data, order = 0, ...)
}
\arguments{
\item{data}{A numeric vector, a matrix, a data frame or a time series object.}

\item{order}{A positive integer specifying the order of the AR model.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}. One special argument can be passed here is
\code{include.mean}, which is a logical value indicating whether the
mean should be included in the model. The default value is \code{TRUE}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_ar]{fastcpd_ar()}} and \code{\link[=fastcpd.ar]{fastcpd.ar()}} are
wrapper functions of \code{\link[=fastcpd]{fastcpd()}} to find change points in
AR(\eqn{p}) models. The function is similar to \code{\link[=fastcpd]{fastcpd()}} except that
the data is by default a one-column matrix or univariate vector
and thus a formula is not required here.
}
\examples{
set.seed(1)
n <- 1000
x <- rep(0, n + 3)
for (i in 1:600) {
  x[i + 3] <- 0.6 * x[i + 2] - 0.2 * x[i + 1] + 0.1 * x[i] + rnorm(1, 0, 3)
}
for (i in 601:1000) {
  x[i + 3] <- 0.3 * x[i + 2] + 0.4 * x[i + 1] + 0.2 * x[i] + rnorm(1, 0, 3)
}
result <- fastcpd.ar(x[3 + seq_len(n)], 3)
summary(result)
plot(result)
set.seed(1)
n <- 1000
x <- rep(0, n + 3)
for (i in 1:600) {
  x[i + 3] <- 0.6 * x[i + 2] - 0.2 * x[i + 1] + 0.1 * x[i] + rnorm(1, 0, 3)
}
for (i in 601:1000) {
  x[i + 3] <- 0.3 * x[i + 2] + 0.4 * x[i + 1] + 0.2 * x[i] + rnorm(1, 0, 3)
}
result <-
  fastcpd.ar(x[3 + seq_len(n)], 3, beta = "MDL", cost_adjustment = "MDL")
summary(result)
plot(result)
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
