% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.r
\name{c,GRaster-method}
\alias{c,GRaster-method}
\alias{c}
\title{"Stack" GRasters}
\usage{
\S4method{c}{GRaster}(x, ...)
}
\arguments{
\item{x}{A \code{GRaster} or a \code{GVector}.}

\item{...}{One or more \code{GRaster}s, one or more \code{GVector}s, a list of \code{GRaster}s, or a list of \code{GVector}s. You can use a mix of lists and individual rasters or vectors.}
}
\value{
A \code{GRaster}.
}
\description{
\code{GRaster}s can be "stacked" using this function, effectively creating a multi-layered raster. This is different from creating a 3-dimensional raster, though such an effect can be emulated using stacking. \code{GVector}s can be combined into a single vector.  Stacks can only be created when:
\itemize{
\item All objects are the same class (either all \code{GRaster}s or all \code{GVector}s).
\item All objects have the same coordinate reference system (see crs()).
\item Horizontal extents are the same (see \code{\link[=ext]{ext()}}).
\item Horizontal dimensions are the same (see \code{\link[=res]{res()}}).
\item The topology (2- or 3-dimensional) must be the same. If 3D, then all rasters must have the same number of depths and vertical extents (see \code{\link[=topology]{topology()}}).
}

Data tables associated with \code{GVector}s will be combined if each vector has a table and if each table has the same columns and data types. Otherwise, the data table will be combined using \code{\link[=merge]{merge()}}.
}
\examples{
if (grassStarted()) {

# Setup
madForest2000 <- fastData("madForest2000")
madForest2014 <- fastData("madForest2014")

# Convert SpatRasters to GRasters:
forest2000 <- fast(madForest2000)
forest2014 <- fast(madForest2014)

# Combine:
forest <- c(forest2000, forest2014)
forest

nlyr(forest)

}
}
\seealso{
\link{add<-}, \code{\link[terra:c]{terra::c()}}, \code{\link[terra]{add<-}}
}
