% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fastml.R
\name{predict.fastml}
\alias{predict.fastml}
\title{Predict method for fastml objects}
\usage{
\method{predict}{fastml}(
  object,
  newdata,
  type = "auto",
  model_name = NULL,
  verbose = FALSE,
  postprocess_fn = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted `fastml` object created by the `fastml()` function.}

\item{newdata}{A data frame or tibble containing new predictor data for which to generate predictions.}

\item{type}{Type of prediction to return. One of `"auto"` (default), `"class"`, `"prob"`, or `"numeric"`.
- `"auto"`: chooses `"class"` for classification and `"numeric"` for regression.
- `"prob"`: returns class probabilities (only for classification).
- `"class"`: returns predicted class labels.
- `"numeric"`: returns predicted numeric values (for regression).}

\item{model_name}{(Optional) Name of a specific model to use when `object$best_model` contains multiple models.}

\item{verbose}{Logical; if `TRUE`, prints progress messages showing which models are used during prediction.}

\item{postprocess_fn}{(Optional) A function to apply to the final predictions (e.g., inverse transforms, thresholding).}

\item{...}{Additional arguments (currently unused).}
}
\value{
A vector of predictions, or a named list of predictions (if multiple models are used).
        If `postprocess_fn` is supplied, its output will be returned instead.
}
\description{
Generates predictions from a trained `fastml` object on new data.
Supports both single-model and multi-model workflows, and handles classification
and regression tasks with optional post-processing and verbosity.
}
\examples{
\dontrun{
  model <- fastml(iris, label = "Species")
  test_data <- sanitize(iris[1:4])
  preds <- predict(model, newdata = test_data)
  probs <- predict(model, newdata = test_data, type = "prob")
  single_model_preds <- predict(model, newdata = test_data, model_name = "rand_forest (ranger)")
}
}
