% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_lime.R
\name{explain_lime}
\alias{explain_lime}
\title{Generate LIME explanations for a fastml model}
\usage{
explain_lime(object, n_features = 5, n_labels = 1, ...)
}
\arguments{
\item{object}{A `fastml` object.}

\item{n_features}{Number of features to show in the explanation. Default 5.}

\item{n_labels}{Number of labels to explain (classification only). Default 1.}

\item{...}{Additional arguments passed to `lime::explain`.}
}
\value{
An object produced by `lime::explain`.
}
\description{
Creates a `lime` explainer using the processed training data stored in the
`fastml` object and returns feature explanations for new observations.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
explain_lime(model)
}
}
