% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.holme.kim.R
\name{net.holme.kim}
\alias{net.holme.kim}
\title{Holme-Kim Network}
\usage{
net.holme.kim(n, m, pt)
}
\arguments{
\item{n}{Number of nodes of the network.}

\item{m}{Number of nodes to which a new node connects at each iteration.}

\item{pt}{Triad formation probability after each preferential attachment mechanism.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a scale-free network with relatively high clustering, comparing to B-A networks (Holme and Kim, 1999).
}
\details{
The Holme-Kim network model is a simple extension of B-A model. It adds an additional step, called "Triad formation", with the probability \emph{pt} that compensates the low clustering in B-A networks.
}
\examples{
\dontrun{
x <- net.holme.kim (1000, 20, 0.1)}
}
\references{
Holme, Petter, and Beom Jun Kim. "Growing scale-free networks with tunable clustering."Physical review E65, no. 2 (2002): 026107.
}
\author{
Xu Dong, Nazrul Shaikh
}
