% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norta.R
\name{fh_bounds}
\alias{fh_bounds}
\title{Get Fréchet-Hoefding bounds}
\usage{
fh_bounds(dist1 = "norm", dist2 = "norm", params1 = list(), params2 = list())
}
\arguments{
\item{dist1}{The target distribution function for variable 1 (e.g., norm, binom, gamma, truncnorm)}

\item{dist2}{The target distribution function for variable 2}

\item{params1}{Arguments to pass to the r{dist} function for distribution 1}

\item{params2}{Arguments to pass to the r{dist} function for distribution 2}
}
\value{
a list of the min and max possible values
}
\description{
Fréchet-Hoefding bounds are the limits to a correlation between different distributions.
}
\examples{
fh_bounds(dist1 = "pois", 
         dist2 = "unif", 
         params1 = list(lambda = 3), 
         params2 = list(min = 0, max = 100))
}
