% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/familias2linkdat.R
\name{Familias2linkdat}
\alias{Familias2linkdat}
\alias{readFamiliasLoci}
\alias{connectedComponentsfb}
\title{Convert 'Familias' output to linkdat objects}
\usage{
Familias2linkdat(familiasped, datamatrix, loci)

readFamiliasLoci(loci)

connectedComponentsfb(ID, FID, MID)
}
\arguments{
\item{familiasped}{A \code{FamiliasPedigree} object or a
list of such.}

\item{datamatrix}{A data frame with two columns per marker (one for each
allele) and one row per individual.}

\item{loci}{A \code{FamiliasLocus} object or a list of such.}

\item{ID}{An integer vector: Individual ID.}

\item{FID}{An integer vector: ID of father.}

\item{MID}{An integer vector: ID of mother.}
}
\value{
A \code{\link{linkdat}} object, or a list of such.
}
\description{
This function is extracted from paramlik package, not currently maintained.
Familias is a widely used program for computations in forensic genetics. The
function documented here facilitates the use of \code{paramlink} for
specialized computations which are not implemented in Familias, e.g.
conditional simulations.
}
\details{
The Familias program represents pedigrees and marker data in a way that
differs from \code{paramlink} in several ways, mostly because of
\code{paramlink}'s stricter definition of a 'pedigree'. In \code{paramlink},
a pedigree must be connected, have numerical IDs, and each member must have
either 0 or 2 parentsfb present in the pedigree. None of this is required by
\code{FamiliasPedigree} objects. The conversion function
\code{Familias2linkdat} takes care of all of these potential differences: It
converts each \code{FamiliasPedigree} into a list of connected linkdat objects,
additional parentsfb are added where needed, and non-numerical ID labels are
stored in the \code{plot.labels} slot of the linkdat object(s).
}
\references{
Windows Familias is freely available from
\url{https://familias.name}.
}
\author{
Magnus Dehli Vigeland, Thore Egeland
}
