% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedModify.R
\name{pedModify}
\alias{pedModify}
\alias{addOffspring}
\alias{removeIndividualsfb}
\alias{trim}
\alias{relabelfb}
\title{Modify the pedigree of 'linkdat' objects}
\usage{
addOffspring(
  x,
  father,
  mother,
  noffs,
  ids = NULL,
  sex = 1,
  aff = 1,
  verbose = TRUE
)

removeIndividualsfb(x, ids, verbose = TRUE)

trim(x, keep = c("available", "affected"), return.ids = FALSE, verbose = TRUE)

relabelfb(x, new, old)
}
\arguments{
\item{x}{A \code{linkdat} object}

\item{father, mother}{Integers indicating the IDs of parentsfb. If missing, a
new founder individual is created (whose ID will be 1+the largest ID
already in the pedigree).}

\item{noffs}{A single integer indicating the number of offspringfb to be
created.}

\item{ids}{individuals}

\item{sex, aff}{Integer vectors indicating the gender and affection statuses
of the offspringfb to be created (recycled if less than \code{noffs}
elements).}

\item{verbose}{A logical: Verbose output or not.}

\item{keep}{A character, either 'available' (trimming the pedigree for
unavailable members) or 'affected' (trimming for unaffected members).}

\item{return.ids}{A logical. If FALSE, the trimmed pedigree is returned as a
new \code{linkdat} object. If TRUE, a vector containing the IDs of
'removable' individuals is returned}

\item{new}{a numeric containing new labels to replace those in \code{old}.}

\item{old}{a numeric containing ID labels to be replaced by those in
\code{new}. If missing, \code{old} is set to \code{x$orig.ids}, i.e. all
members in their original order.}
}
\value{
The modified \code{linkdat} object.
}
\description{
Functions to modify the pedigree of a 'linkdat' object.
}
\details{
When removing an individual, all descendantsfb are also removed as well as
founders remaining without offspringfb.
}
\seealso{
\code{linkdat}, \code{nuclearPed}
}
