% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.perf.R
\name{perf.fbroc.roc}
\alias{perf.fbroc.roc}
\title{Calculate performance for bootstrapped ROC curve}
\usage{
\method{perf}{fbroc.roc}(roc, metric = "auc", conf.level = 0.95,
  tpr = NULL, fpr = NULL, ...)
}
\arguments{
\item{roc}{An object of class \code{fbroc.roc}.}

\item{metric}{A performance metric. Select "auc" for the AUC, "tpr" for the TPR at a fixed
FPR and "fpr" for the FPR at a fixed TPR.}

\item{conf.level}{The confidence level of the confidence interval.}

\item{tpr}{The fixed TPR at which the FPR is to be evaluated when \code{fpr} is selected as metric.}

\item{fpr}{The fixed FPR at which the TPR is to be evaluated when \code{tpr} is selected as metric.}

\item{...}{Further arguments, that are not used at this time.}
}
\value{
A list of class \code{fbroc.perf}, containing the elements:
\item{Observed.Performance}{The observed performance.}
\item{CI.Performance}{Quantile based confidence interval for the performance.}
\item{conf.level}{Confidence level of the confidence interval.}
\item{metric}{Used performance metric.}
\item{params}{Parameters used to further specifiy metric, e.g. fixed TPR.}
\item{n.boot}{Number of bootstrap replicates used.}
\item{boot.results}{Performance in each bootstrap replicate.}
}
\description{
Calculates different performance metric for ROC curves based on the bootstrap
results saved in an object of class \code{fbroc.roc}. Confidence intervals
are included.
}
\examples{
y <- rep(c(TRUE, FALSE), each = 500)
x <- rnorm(1000) + y
result.boot <- boot.roc(x, y, n.boot = 100)
perf(result.boot, "auc")
perf(result.boot, "auc", conf.level = 0.99)
}
\seealso{
\code{\link{boot.roc}}, \code{\link{print.fbroc.perf}},
  \code{\link{plot.fbroc.perf}}
}

