% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremal_depth.R
\name{extremal_depth}
\alias{extremal_depth}
\title{Compute extremal depth for functional data}
\usage{
extremal_depth(dt)
}
\arguments{
\item{dt}{A numeric matrix or dataframe of size \eqn{n} observations/curves by \eqn{p} domain/evaluation
points.}
}
\value{
A vector containing the extremal depths of the rows of \code{dt}.
}
\description{
Compute extremal depth for functional data
}
\details{
This function computes the extremal depth a univariate functional data. The extremal depth of a function
\eqn{g} with respect to a set of function \eqn{S} denoted by \eqn{ED(g, S)} is the proportion
of functions in \eqn{S} that is more extreme than \eqn{g}. The functions are ordered using depths cumulative
distribution functions (d-CDFs). Extremal depth like the name implies is based on extreme outlyingness and it
penalizes functions that are outliers even for a small part of the domain. Proposed/mentioned in
Narisetty and Nair (2016)\href{https://doi.org/10.1080/01621459.2015.1110033}{<doi:10.1080/01621459.2015.1110033>}.
}
\examples{
data(sim_data1)
ex_depths <- extremal_depth(sim_data1$data)
# order functions from deepest to most outlying
order(ex_depths, decreasing = TRUE)
}
\references{
Narisetty, N. N., & Nair, V. N. (2016). Extremal depth for functional data and applications.
\emph{Journal of the American Statistical Association}, 111(516), 1705-1714.

 @seealso \code{\link{total_variation_depth}} for functional data.
}
\author{
Oluwasegun Ojo
}
